import type { StreamType } from '@video/common/types/peer.types.ts';

export interface InfoMsg {
  type: 'info',
  msg: unknown;
}

export interface StreamInfoMsg {
  type: 'stream',
  streamId: string;
  streamType: StreamType;
}

export interface StreamStateMsg {
  type: 'stream-state',
  streamId: string;
  audio: boolean;
  video: boolean;
}

export interface StreamRemovedMsg {
  type: 'stream-removed',
  streamId: string;
}

export interface DisconnectMsg {
  type: 'disconnect';
}

export type Msg = InfoMsg | DisconnectMsg | StreamInfoMsg | StreamStateMsg | StreamRemovedMsg;
