"use strict";
/*
 Copyright (C) 2016, 2018 - 2020 3NSoft Inc.
 
 This program is free software: you can redistribute it and/or modify it under
 the terms of the GNU General Public License as published by the Free Software
 Foundation, either version 3 of the License, or (at your option) any later
 version.
 
 This program is distributed in the hope that it will be useful, but
 WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 See the GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License along with
 this program. If not, see <http://www.gnu.org/licenses/>. */
Object.defineProperty(exports, "__esModule", { value: true });
exports.utf8 = exports.base64urlSafe = exports.base64 = exports.EMPTY_BUFFER = void 0;
exports.toBuffer = toBuffer;
exports.bufFromJson = bufFromJson;
exports.joinByteArrs = joinByteArrs;
exports.byteLengthIn = byteLengthIn;
exports.EMPTY_BUFFER = Buffer.alloc(0);
/**
 * Buffer and Uint8Array are intimately linked in Node, starting with some
 * version. As a result, Uint8Array can be efficiently turned into Buffer,
 * or Buffer can be used as Uint8Array.
 * This function checks if given argument is a Buffer, and, if not, does
 * proper enveloping.
 * @param bytes that we need to have as a Buffer
 * @return Buffer with given bytes.
 */
function toBuffer(bytes) {
    if (Buffer.isBuffer(bytes)) {
        return bytes;
    }
    if (bytes.length === 0) {
        return exports.EMPTY_BUFFER;
    }
    return Buffer.from(bytes.buffer, bytes.byteOffset, bytes.length);
}
/**
 * Node's JSON.stringify turns Buffer into a particular json.
 * This function turns this json back to Buffer.
 * @param json of a Buffer
 * @return a Buffer reconstructed from a given json.
 */
function bufFromJson(json) {
    if ((json.type !== 'Buffer') || !Array.isArray(json.data)) {
        throw new Error('Given argument is not a buffer json.');
    }
    return Buffer.from(json.data);
}
var base64;
(function (base64) {
    function pack(bytes) {
        const buf = toBuffer(bytes);
        return buf.toString('base64');
    }
    base64.pack = pack;
    function open(str) {
        return Buffer.from(str, 'base64');
    }
    base64.open = open;
})(base64 || (exports.base64 = base64 = {}));
Object.freeze(base64);
var base64urlSafe;
(function (base64urlSafe) {
    function pack(bytes) {
        const str = base64.pack(bytes);
        return str
            .replace(/\+/g, '-')
            .replace(/\//g, '_');
    }
    base64urlSafe.pack = pack;
    function open(str) {
        str = str
            .replace(/-/g, '+')
            .replace(/_/g, '/');
        return base64.open(str);
    }
    base64urlSafe.open = open;
})(base64urlSafe || (exports.base64urlSafe = base64urlSafe = {}));
Object.freeze(base64);
var utf8;
(function (utf8) {
    function pack(str) {
        return Buffer.from(str, 'utf8');
    }
    utf8.pack = pack;
    function open(bytes) {
        const buf = toBuffer(bytes);
        return buf.toString('utf8');
    }
    utf8.open = open;
})(utf8 || (exports.utf8 = utf8 = {}));
Object.freeze(utf8);
function joinByteArrs(arrs) {
    let totalLen = 0;
    for (const arr of arrs) {
        totalLen += arr.length;
    }
    const allBytes = new Uint8Array(totalLen);
    let ofs = 0;
    for (const arr of arrs) {
        allBytes.set(arr, ofs);
        ofs += arr.length;
    }
    return allBytes;
}
function byteLengthIn(arrs) {
    let len = 0;
    for (let i = 0; i < arrs.length; i += 1) {
        len += arrs[i].length;
    }
    return len;
}
Object.freeze(exports);
