"use strict";
/*
 Copyright (C) 2020 3NSoft Inc.

 This program is free software: you can redistribute it and/or modify it under
 the terms of the GNU General Public License as published by the Free Software
 Foundation, either version 3 of the License, or (at your option) any later
 version.

 This program is distributed in the hope that it will be useful, but
 WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 this program. If not, see <http://www.gnu.org/licenses/>.
*/
Object.defineProperty(exports, "__esModule", { value: true });
const worker_threads_1 = require("worker_threads");
const path_1 = require("path");
const wasm_mp1_modules_1 = require("./wasm-mp1-modules");
const fs_1 = require("fs");
if (!worker_threads_1.parentPort) {
    throw new Error(`Missing expected parentPort. Is this called within WebWorker process?`);
}
const wasmFName = 'cryptor.wasm';
const wasmModPath = (0, path_1.join)(worker_threads_1.workerData.loadDir, wasmFName);
const wasmInstance = (0, wasm_mp1_modules_1.startWasmFrom)((0, fs_1.readFileSync)(wasmModPath));
wasmInstance.setMsgListener(msg => worker_threads_1.parentPort.postMessage(msg));
worker_threads_1.parentPort.on('message', (msg) => {
    try {
        wasmInstance.sendMsgIntoWASM(msg);
    }
    catch (err) {
        console.error(err);
    }
});
