/*
 Copyright (C) 2018, 2020 - 2021 3NSoft Inc.

 This program is free software: you can redistribute it and/or modify it under
 the terms of the GNU General Public License as published by the Free Software
 Foundation, either version 3 of the License, or (at your option) any later
 version.

 This program is distributed in the hope that it will be useful, but
 WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 this program. If not, see <http://www.gnu.org/licenses/>.
*/
class ContSink {
    sink;
    position;
    constructor(sink, position) {
        this.sink = sink;
        this.position = position;
        Object.seal(this);
    }
    async write(bytes, err) {
        if (bytes) {
            const len = bytes.length;
            await this.sink.splice(this.position, len, bytes);
            this.position += len;
        }
        else {
            await this.sink.done(err);
        }
    }
    wrap() {
        const f = this.write.bind(this);
        return f;
    }
}
Object.freeze(ContSink.prototype);
Object.freeze(ContSink);
export function makeContinuousSink(sink, start = 0) {
    const contSink = new ContSink(sink, start);
    return contSink.wrap();
}
export async function appendFiniteSink(sink, bytes, closeSink = true) {
    const initSize = await sink.getSize();
    await sink.splice(initSize, 0, bytes);
    if (closeSink) {
        await sink.done();
    }
}
//# sourceMappingURL=sink-utils.js.map