/*
 Copyright (C) 2021, 2024 3NSoft Inc.

 This program is free software: you can redistribute it and/or modify it under
 the terms of the GNU General Public License as published by the Free Software
 Foundation, either version 3 of the License, or (at your option) any later
 version.

 This program is distributed in the hope that it will be useful, but
 WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 this program. If not, see <http://www.gnu.org/licenses/>.
*/

export function makeRuntimeException<T extends web3n.RuntimeException>(
	type: NonNullable<T['type']>, params: Partial<T>, flags: Partial<T>
): T {
	const exc = {
		runtimeException: true,
		type,
	} as T;
	for (const [field, val] of Object.entries(params)) {
		if (val !== undefined) {
			exc[field as keyof T] = val;
		}
	}
	for (const [field, val] of Object.entries(flags)) {
		if (val === true) {
			exc[field as keyof T] = val;
		}
	}
	return exc as T;
}
