import * as w3n from 'w3n:preload.js';

console.log(`
  --- 🏁 from embedded deno ---
w3n fields: ${JSON.stringify(Object.keys(w3n))}
`);

for (let i=0; i<100; i+=1) {
  try {
    const ev = await w3n.nextIpcEvents();
    switch (ev.event) {
      case 'data': {
        console.log(`js@deno: echoing data back:`, ev.data.length);
        await w3n.send(ev.data, 200);
        break;
      }
      case 'exit': {
        console.log(`js@deno: received event`, ev);
        break;
      }
      default: {
        console.log(`js@deno: received event`, ev);
      }
    }
  } catch (err) {
    console.error(`js@deno: received an error`, err);
    break;
  }
}

try {
  await w3n.exit(1000);
} catch (err) {
  console.error(`error an in attempt to exit`, err);
}